#include <windows.h>
#include <stdio.h>

char	szClass[132] = "ConsoleWindowClass";
char	szWndText[100] = "";
char	buf[256] = "";
HWND	hWnd = 0;

/*****************************************************************************\
*
*  FUNCTION:    EnumWndProc - EnumWindows callback function.
*
\*****************************************************************************/

BOOL CALLBACK
EnumWndProc(HWND hwnd, LPARAM lParam)
{
	int		len = strlen((char *)lParam);

	if (GetWindowText(hwnd, szWndText, sizeof(szWndText)-1)
	 && (_strnicmp((const char *)lParam, szWndText, len) == 0))
	{
		GetClassName(hWnd = hwnd, szClass, sizeof(szClass)-1);
		return(FALSE);
	}

	return(TRUE);
}

/*****************************************************************************\
*
*  FUNCTION:    WinMain (standard WinMain INPUTS)
*				returns 2 if found Settings App
*               returns 1 if should attempt to kill SystemSettings.exe
*               returns 0 otherwise
*
\*****************************************************************************/

int WINAPI
WinMain(
HINSTANCE	hInstance,
HINSTANCE	hPrevInstance,
LPSTR		lpCmdLine,
int 		nCmdShow)
{
	WINDOWPLACEMENT	wp;

	EnumWindows(EnumWndProc, (LPARAM)"Settings");

	if (!hWnd)
		return(0);	// Didn't find Settings

	// Did find Settings - now determine if it is Settings App or not
	if (GetWindowPlacement(hWnd, &wp))
	{
#if 0
		GetWindowText(hWnd, szWndText, sizeof(szWndText)-1);
		sprintf(buf, "hWnd = 0x%08x\nClass = %s\nTitle = %s\nshowCmd = %d", 
									hWnd, szClass, szWndText, wp.showCmd);
		MessageBox(NULL, buf, "Found Settings", MB_OK);
#endif
		if (wp.showCmd	== SW_SHOWMAXIMIZED)
			return(2);	// Found Maxed Setting App - don't attempt to kill
	}
	return(1);	// Didn't find Settings App, so go kill SystemSettings.exe
}
